/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import optifine.Config;
import optifine.GuiScreenOF;
import optifine.Lang;
import optifine.StrUtils;
import shadersmod.client.GuiButtonShaderOption;
import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderOptionProfile;
import shadersmod.client.ShaderOptionScreen;
import shadersmod.client.Shaders;

public class GuiShaderOptions
extends GuiScreenOF {
    private GuiScreen prevScreen;
    protected String title = "Shader Options";
    private GameSettings settings;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;
    private String screenName = null;
    private String screenText = null;
    private boolean changed = false;
    public static final String OPTION_PROFILE = "<profile>";
    public static final String OPTION_EMPTY = "<empty>";
    public static final String OPTION_REST = "*";

    public GuiShaderOptions(GuiScreen guiscreen, GameSettings gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    public GuiShaderOptions(GuiScreen guiscreen, GameSettings gamesettings, String screenName) {
        this(guiscreen, gamesettings);
        this.screenName = screenName;
        if (screenName != null) {
            this.screenText = Shaders.translate("screen." + screenName, screenName);
        }
    }

    @Override
    public void initGui() {
        this.title = I18n.format("of.options.shaderOptionsTitle", new Object[0]);
        int i = 100;
        int j = 0;
        int k = 30;
        int l = 20;
        int i1 = this.width - 130;
        int j1 = 120;
        int k1 = 20;
        int l1 = 2;
        ShaderOption[] ashaderoption = Shaders.getShaderPackOptions(this.screenName);
        if (ashaderoption != null) {
            if (ashaderoption.length > 18) {
                l1 = ashaderoption.length / 9 + 1;
            }
            int i2 = 0;
            while (i2 < ashaderoption.length) {
                ShaderOption shaderoption = ashaderoption[i2];
                if (shaderoption != null && shaderoption.isVisible()) {
                    int j2 = i2 % l1;
                    int k2 = i2 / l1;
                    int l2 = Math.min(this.width / l1, 200);
                    j = (this.width - l2 * l1) / 2;
                    int i3 = j2 * l2 + 5 + j;
                    int j3 = k + k2 * l;
                    int k3 = l2 - 10;
                    String s = this.getButtonText(shaderoption, k3);
                    GuiButtonShaderOption guibuttonshaderoption = new GuiButtonShaderOption(i + i2, i3, j3, k3, k1, shaderoption, s);
                    guibuttonshaderoption.enabled = shaderoption.isEnabled();
                    this.buttonList.add(guibuttonshaderoption);
                }
                ++i2;
            }
        }
        this.buttonList.add(new GuiButton(201, this.width / 2 - j1 - 20, this.height / 6 + 168 + 11, j1, k1, I18n.format("controls.reset", new Object[0])));
        this.buttonList.add(new GuiButton(200, this.width / 2 + 20, this.height / 6 + 168 + 11, j1, k1, I18n.format("gui.done", new Object[0])));
    }

    private String getButtonText(ShaderOption so, int btnWidth) {
        String s = so.getNameText();
        if (so instanceof ShaderOptionScreen) {
            ShaderOptionScreen shaderoptionscreen = (ShaderOptionScreen)so;
            return String.valueOf(s) + "...";
        }
        FontRenderer fontrenderer = Config.getMinecraft().fontRendererObj;
        int i = fontrenderer.getStringWidth(": " + Lang.getOff()) + 5;
        while (fontrenderer.getStringWidth(s) + i >= btnWidth && s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        String s1 = so.isChanged() ? so.getValueColor(so.getValue()) : "";
        String s2 = so.getValueText(so.getValue());
        return String.valueOf(s) + ": " + s1 + s2;
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton.enabled) {
            if (guibutton.id < 200 && guibutton instanceof GuiButtonShaderOption) {
                GuiButtonShaderOption guibuttonshaderoption = (GuiButtonShaderOption)guibutton;
                ShaderOption shaderoption = guibuttonshaderoption.getShaderOption();
                if (shaderoption instanceof ShaderOptionScreen) {
                    String s = shaderoption.getName();
                    GuiShaderOptions guishaderoptions = new GuiShaderOptions(this, this.settings, s);
                    this.mc.displayGuiScreen(guishaderoptions);
                    return;
                }
                if (GuiShaderOptions.isShiftKeyDown()) {
                    shaderoption.resetValue();
                } else {
                    shaderoption.nextValue();
                }
                this.updateAllButtons();
                this.changed = true;
            }
            if (guibutton.id == 201) {
                ShaderOption[] ashaderoption = Shaders.getChangedOptions(Shaders.getShaderPackOptions());
                int i = 0;
                while (i < ashaderoption.length) {
                    ShaderOption shaderoption1 = ashaderoption[i];
                    shaderoption1.resetValue();
                    this.changed = true;
                    ++i;
                }
                this.updateAllButtons();
            }
            if (guibutton.id == 200) {
                if (this.changed) {
                    Shaders.saveShaderPackOptions();
                    this.changed = false;
                    Shaders.uninit();
                }
                this.mc.displayGuiScreen(this.prevScreen);
            }
        }
    }

    @Override
    protected void actionPerformedRightClick(GuiButton btn) {
        if (btn instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption guibuttonshaderoption = (GuiButtonShaderOption)btn;
            ShaderOption shaderoption = guibuttonshaderoption.getShaderOption();
            if (GuiShaderOptions.isShiftKeyDown()) {
                shaderoption.resetValue();
            } else {
                shaderoption.prevValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        if (this.changed) {
            Shaders.saveShaderPackOptions();
            this.changed = false;
            Shaders.uninit();
        }
    }

    private void updateAllButtons() {
        for (GuiButton guibutton : this.buttonList) {
            if (!(guibutton instanceof GuiButtonShaderOption)) continue;
            GuiButtonShaderOption guibuttonshaderoption = (GuiButtonShaderOption)guibutton;
            ShaderOption shaderoption = guibuttonshaderoption.getShaderOption();
            if (shaderoption instanceof ShaderOptionProfile) {
                ShaderOptionProfile shaderoptionprofile = (ShaderOptionProfile)shaderoption;
                shaderoptionprofile.updateProfile();
            }
            guibuttonshaderoption.displayString = this.getButtonText(shaderoption, guibuttonshaderoption.getButtonWidth());
        }
    }

    @Override
    public void drawScreen(int x, int y, float f) {
        this.drawDefaultBackground();
        if (this.screenText != null) {
            GuiShaderOptions.drawCenteredString(this.fontRendererObj, this.screenText, this.width / 2, 15.0f, 0xFFFFFF);
        } else {
            GuiShaderOptions.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 15.0f, 0xFFFFFF);
        }
        super.drawScreen(x, y, f);
        if (Math.abs(x - this.lastMouseX) <= 5 && Math.abs(y - this.lastMouseY) <= 5) {
            this.drawTooltips(x, y, this.buttonList);
        } else {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
        }
    }

    private void drawTooltips(int x, int y, List buttons) {
        int i = 700;
        if (System.currentTimeMillis() >= this.mouseStillTime + (long)i) {
            int j = this.width / 2 - 150;
            int k = this.height / 6 - 7;
            if (y <= k + 98) {
                k += 105;
            }
            int l = j + 150 + 150;
            int i1 = k + 84 + 10;
            GuiButton guibutton = GuiShaderOptions.getSelectedButton(buttons, x, y);
            if (guibutton instanceof GuiButtonShaderOption) {
                GuiButtonShaderOption guibuttonshaderoption = (GuiButtonShaderOption)guibutton;
                ShaderOption shaderoption = guibuttonshaderoption.getShaderOption();
                String[] astring = this.makeTooltipLines(shaderoption, l - j);
                if (astring == null) {
                    return;
                }
                this.drawGradientRect(j, k, l, i1, -536870912, -536870912);
                int j1 = 0;
                while (j1 < astring.length) {
                    String s = astring[j1];
                    int k1 = 0xDDDDDD;
                    if (s.endsWith("!")) {
                        k1 = 0xFF2020;
                    }
                    this.fontRendererObj.drawStringWithShadow(s, j + 5, k + 5 + j1 * 11, k1);
                    ++j1;
                }
            }
        }
    }

    private String[] makeTooltipLines(ShaderOption so, int width) {
        if (so instanceof ShaderOptionProfile) {
            return null;
        }
        String s = so.getNameText();
        String s1 = Config.normalize(so.getDescriptionText()).trim();
        String[] astring = this.splitDescription(s1);
        String s2 = null;
        if (!s.equals(so.getName()) && this.settings.advancedItemTooltips) {
            s2 = "\u00a78" + Lang.get("of.general.id") + ": " + so.getName();
        }
        String s3 = null;
        if (so.getPaths() != null && this.settings.advancedItemTooltips) {
            s3 = "\u00a78" + Lang.get("of.general.from") + ": " + Config.arrayToString(so.getPaths());
        }
        String s4 = null;
        if (so.getValueDefault() != null && this.settings.advancedItemTooltips) {
            String s5 = so.isEnabled() ? so.getValueText(so.getValueDefault()) : Lang.get("of.general.ambiguous");
            s4 = "\u00a78" + Lang.getDefault() + ": " + s5;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(s);
        list.addAll(Arrays.asList(astring));
        if (s2 != null) {
            list.add(s2);
        }
        if (s3 != null) {
            list.add(s3);
        }
        if (s4 != null) {
            list.add(s4);
        }
        String[] astring1 = this.makeTooltipLines(width, list);
        return astring1;
    }

    private String[] splitDescription(String desc) {
        if (desc.length() <= 0) {
            return new String[0];
        }
        desc = StrUtils.removePrefix(desc, "//");
        String[] astring = desc.split("\\. ");
        int i = 0;
        while (i < astring.length) {
            astring[i] = "- " + astring[i].trim();
            astring[i] = StrUtils.removeSuffix(astring[i], ".");
            ++i;
        }
        return astring;
    }

    private String[] makeTooltipLines(int width, List<String> args) {
        FontRenderer fontrenderer = Config.getMinecraft().fontRendererObj;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < args.size()) {
            String s = args.get(i);
            if (s != null && s.length() > 0) {
                for (Object s1 : fontrenderer.listFormattedStringToWidth(s, width)) {
                    list.add((String)s1);
                }
            }
            ++i;
        }
        String[] astring = list.toArray(new String[list.size()]);
        return astring;
    }
}

