/*
 * Decompiled with CFR 0.152.
 */
package astra.ui.clickgui.comp;

import astra.hud.mod.HudMod;
import astra.util.RoundedUtils;
import astra.util.font.FontUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;

public class ModButton {
    public int w;
    public int h;
    public HudMod m;
    private boolean animating;
    private long animationStartTime;
    private long animationDuration = 200L;
    private int x;
    private int y;
    private int width;
    private int height;
    private String label;
    private boolean enabled;
    private boolean hovered;

    public ModButton() {
        this.x = 0;
        this.y = 0;
        this.w = 0;
        this.h = 0;
        this.m = null;
    }

    public ModButton(int x, int y, int w, int h, HudMod m) {
        this.x = x;
        this.y = y;
        this.w = 100;
        this.h = 100;
        this.m = m;
        this.enabled = this.enabled;
    }

    public void drawDropShadow() {
        if (this.hovered) {
            int shadowOffset = 2;
            int shadowColor = new Color(0, 0, 0, 100).getRGB();
            RoundedUtils.drawRoundedRect(this.x - shadowOffset, this.y - shadowOffset, this.x + this.w + shadowOffset, this.y + this.h + shadowOffset, 5.0f, shadowColor);
        }
    }

    public void draw() {
        if (this.m != null) {
            int buttonColor = new Color(51, 51, 51).getRGB();
            RoundedUtils.drawRoundedRect(this.x, this.y, this.x + this.w, this.y + this.h, 5.0f, buttonColor);
            int statusColor = Color.WHITE.getRGB();
            int statusBoxHeight = 20;
            String modName = this.m.name;
            int modNameWidth = Minecraft.getMinecraft().fontRendererObj.getStringWidth(modName);
            int modNameX = this.x + (this.w - modNameWidth) / 2;
            int modNameY = this.y + (this.h - Minecraft.getMinecraft().fontRendererObj.FONT_HEIGHT) / 2;
            if (this.animating) {
                int statusBoxColor;
                int endStatusBoxColor;
                int startStatusBoxColor;
                long currentTime = System.currentTimeMillis();
                float progress = Math.min(1.0f, (float)(currentTime - this.animationStartTime) / (float)this.animationDuration);
                if (this.m.isEnabled()) {
                    startStatusBoxColor = new Color(74, 74, 74).getRGB();
                    endStatusBoxColor = new Color(119, 74, 128).getRGB();
                    statusBoxColor = this.transitionColor(startStatusBoxColor, endStatusBoxColor, progress);
                } else {
                    startStatusBoxColor = new Color(119, 74, 128).getRGB();
                    endStatusBoxColor = new Color(74, 74, 74).getRGB();
                    statusBoxColor = this.transitionColor(startStatusBoxColor, endStatusBoxColor, progress);
                }
                RoundedUtils.drawRoundedRect(this.x, this.y + this.h - statusBoxHeight, this.x + this.w, this.y + this.h, 5.0f, statusBoxColor);
                String statusText = this.m.isEnabled() ? "Enabled" : "Disabled";
                int statusTextWidth = Minecraft.getMinecraft().fontRendererObj.getStringWidth(statusText);
                int statusTextX = this.x + (this.w - statusTextWidth) / 2;
                int statusTextY = this.y + this.h - statusBoxHeight + (statusBoxHeight - Minecraft.getMinecraft().fontRendererObj.FONT_HEIGHT) / 2;
                FontUtil.normal.drawString(statusText, statusTextX, statusTextY, statusColor);
                FontUtil.normal.drawString(modName, modNameX, modNameY, Color.WHITE.getRGB());
            } else {
                int statusBoxColor = this.m.isEnabled() ? new Color(119, 74, 128).getRGB() : new Color(74, 74, 74).getRGB();
                RoundedUtils.drawRoundedRect(this.x, this.y + this.h - statusBoxHeight, this.x + this.w, this.y + this.h, 5.0f, statusBoxColor);
                String statusText = this.m.isEnabled() ? "Enabled" : "Disabled";
                int statusTextWidth = Minecraft.getMinecraft().fontRendererObj.getStringWidth(statusText);
                int statusTextX = this.x + (this.w - statusTextWidth) / 2;
                int statusTextY = this.y + this.h - statusBoxHeight + (statusBoxHeight - Minecraft.getMinecraft().fontRendererObj.FONT_HEIGHT) / 2;
                FontUtil.normal.drawString(statusText, statusTextX, statusTextY, statusColor);
                FontUtil.normal.drawString(modName, modNameX, modNameY, Color.WHITE.getRGB());
            }
        }
    }

    private int transitionColor(int startColor, int endColor, float progress) {
        int startAlpha = startColor >> 24 & 0xFF;
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >> 24 & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int interpolatedAlpha = (int)((float)startAlpha + (float)(endAlpha - startAlpha) * progress);
        int interpolatedRed = (int)((float)startRed + (float)(endRed - startRed) * progress);
        int interpolatedGreen = (int)((float)startGreen + (float)(endGreen - startGreen) * progress);
        int interpolatedBlue = (int)((float)startBlue + (float)(endBlue - startBlue) * progress);
        return interpolatedAlpha << 24 | interpolatedRed << 16 | interpolatedGreen << 8 | interpolatedBlue;
    }

    public void onClick(int mouseX, int mouseY, int button) {
        if (mouseX >= this.x && mouseX <= this.x + this.w && mouseY >= this.y && mouseY <= this.y + this.h) {
            this.m.toggle();
            System.out.println(this.m.name);
            this.animating = true;
            this.animationStartTime = System.currentTimeMillis();
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getHeight() {
        return this.h;
    }

    public String getModName() {
        if (this.m != null) {
            return this.m.name;
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }
}

