/*
 * Decompiled with CFR 0.152.
 */
package astra.ui.clickgui;

import astra.Astra;
import astra.hud.HUDConfigScreen;
import astra.ui.clickgui.comp.ModButton;
import astra.util.RoundedUtils;
import astra.util.font.FontUtil;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class ClickGUI
extends GuiScreen {
    private ResourceLocation playerTexture;
    private ScrollDirection scrollDirection = null;
    ArrayList<ModButton> modButtons = new ArrayList();
    int sidebarWidth = 100;
    int guiWidth = 468;
    int guiHeight = 280;
    int searchBarHeight = 20;
    int searchBarMargin = 7;
    String searchText = "";
    boolean hudConfigScreenOpen = false;
    boolean showColorBar = false;
    int centerX;
    int centerY;
    int sidebarX;
    int sidebarY;
    int imageHeight;
    private int guiX;
    private int guiY;
    private long animationStartTime;
    private long animationDuration = 500L;
    private int initialY;
    private int finalY;
    private int visibleStartIndex = 0;

    @Override
    public void initGui() {
        super.initGui();
        this.finalY = this.height - this.guiHeight;
        this.initialY = this.height;
        this.animationStartTime = System.currentTimeMillis();
        ScaledResolution sr = new ScaledResolution(this.mc);
        this.centerX = sr.getScaledWidth() / 2;
        this.centerY = sr.getScaledHeight() / 2;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int searchBarX = this.centerX - this.guiWidth / 2 + 100;
        int searchBarY = this.centerY - this.guiHeight / 2 + 10;
        int buttonX = searchBarX + 35;
        int buttonY = searchBarY + this.searchBarHeight + 10;
        this.modButtons.add(new ModButton(buttonX, buttonY, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.clientName));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.fps));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.targetHud));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.keystrokes));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.cps));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.toggleSprint));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.fullbright));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.xyz));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.nametag));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.pack));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.server));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.toxic));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.statshud));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.tophat));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.smoothzoom));
        this.modButtons.add(new ModButton(buttonX, buttonY += buttonHeight + buttonSpacing, buttonWidth, buttonHeight, Astra.INSTANCE.hudManager.cape));
        this.visibleStartIndex = 0;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        boolean isHovered1;
        boolean isHovered;
        long currentTime = System.currentTimeMillis();
        float progress = Math.min(1.0f, (float)(currentTime - this.animationStartTime) / (float)this.animationDuration);
        int alpha = (int)(170.0f * progress);
        int currentY = (int)((float)this.initialY + (float)(this.finalY - this.initialY) * progress);
        this.guiX = this.centerX - this.guiWidth / 2;
        this.guiY = currentY - this.guiHeight / 2;
        int guiX2 = this.guiX + this.guiWidth;
        int guiY2 = this.guiY + this.guiHeight;
        int guiColor = new Color(28, 28, 28).getRGB();
        int sidebarX = this.guiX - 25;
        int sidebarY = this.guiY;
        int sidebarWidth = 75;
        int sidebarHeight = this.guiHeight;
        int sidebarColor = new Color(20, 20, 20).getRGB();
        RoundedUtils.drawRoundedRect(sidebarX, sidebarY, sidebarX + sidebarWidth, sidebarY + sidebarHeight, 10.0f, sidebarColor);
        ResourceLocation imageLocation = new ResourceLocation("Astra/logo.png");
        this.mc.getTextureManager().bindTexture(imageLocation);
        int imageWidth = 30;
        int imageHeight = 30;
        ClickGUI.drawScaledCustomSizeModalRect(sidebarX + 15, sidebarY + 5, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight, imageWidth, imageHeight);
        int extendedGuiWidth = this.guiWidth + 50;
        int extendedGuiX2 = this.guiX + extendedGuiWidth;
        int mainContentX = sidebarX + sidebarWidth - 16;
        int mainContentY = this.guiY;
        int mainContentWidth = extendedGuiWidth - sidebarWidth + 10;
        int mainContentHeight = this.guiHeight;
        int mainContentColor = new Color(30, 30, 30).getRGB();
        RoundedUtils.drawRoundedRect(mainContentX, mainContentY, mainContentX + mainContentWidth, mainContentY + mainContentHeight, 10.0f, mainContentColor);
        ArrayList<ModButton> filteredModButtons = new ArrayList<ModButton>();
        for (ModButton modButton : this.modButtons) {
            String modName = modButton.getModName();
            if (modName == null || !modName.toLowerCase().contains(this.searchText.toLowerCase())) continue;
            filteredModButtons.add(modButton);
        }
        int buttonX1 = mainContentX + 10;
        int buttonY1 = mainContentY + 50;
        int buttonSpacing = 10;
        int buttonsPerRow = 4;
        int buttonCount = 0;
        int i = this.visibleStartIndex;
        while (i < filteredModButtons.size()) {
            if (i >= filteredModButtons.size()) break;
            int j = i;
            while (j < i + buttonsPerRow) {
                if (j >= filteredModButtons.size()) break;
                ModButton modButton = (ModButton)filteredModButtons.get(j);
                int row = buttonCount / buttonsPerRow;
                int col = buttonCount % buttonsPerRow;
                int adjustedButtonX = buttonX1 + col * (modButton.getWidth() + buttonSpacing);
                int adjustedButtonY = buttonY1 + row * (modButton.getHeight() + buttonSpacing);
                if (this.scrollDirection == ScrollDirection.UP) {
                    adjustedButtonY = (int)((float)adjustedButtonY + (float)(this.guiHeight + 2 * buttonSpacing) * (1.0f - progress));
                } else if (this.scrollDirection == ScrollDirection.DOWN) {
                    adjustedButtonY = (int)((float)adjustedButtonY - (float)(this.guiHeight + 2 * buttonSpacing) * (1.0f - progress));
                }
                modButton.setPosition(adjustedButtonX, adjustedButtonY);
                modButton.draw();
                ++buttonCount;
                ++j;
            }
            if (buttonCount / buttonsPerRow >= 2) break;
            i += buttonsPerRow;
        }
        ResourceLocation pencilIcon = new ResourceLocation("Astra/pencil.png");
        this.mc.getTextureManager().bindTexture(pencilIcon);
        int buttonWidth = 25;
        int buttonHeight = 25;
        int buttonX = sidebarX + (sidebarWidth - buttonWidth) / 2 - 9;
        int buttonY = sidebarY + sidebarHeight - buttonHeight - 10;
        boolean bl = isHovered = mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight;
        if (isHovered) {
            int hoverBoxColor = new Color(255, 255, 255, 100).getRGB();
            RoundedUtils.drawRoundedRect(buttonX - 2, buttonY - 2, buttonX + buttonWidth + 2, buttonY + buttonHeight + 2, 5.0f, hoverBoxColor);
        }
        ClickGUI.drawScaledCustomSizeModalRect(buttonX, buttonY, 0.0f, 0.0f, buttonWidth, buttonHeight, buttonWidth, buttonHeight, buttonWidth, buttonHeight);
        int buttonAbovePencilX = buttonX;
        int buttonAbovePencilY = buttonY - buttonHeight - 20;
        int buttonAbovePencilWidth = 50;
        int buttonAbovePencilHeight = 20;
        int buttonAbovePencilColor = new Color(255, 0, 0).getRGB();
        boolean isHoveredAbovePencil = mouseX >= buttonAbovePencilX && mouseX <= buttonAbovePencilX + buttonAbovePencilWidth && mouseY >= buttonAbovePencilY && mouseY <= buttonAbovePencilY + buttonAbovePencilHeight;
        int buttonCenterX = sidebarX + (sidebarWidth - 42) / 2;
        int buttonY11 = sidebarY + sidebarHeight - 15 - 60;
        int buttonWidth1 = 25;
        int buttonHeight1 = 25;
        ResourceLocation buttonIcon = new ResourceLocation("Astra/color.png");
        this.mc.getTextureManager().bindTexture(buttonIcon);
        boolean bl2 = isHovered1 = mouseX >= buttonCenterX && mouseX <= buttonCenterX + buttonWidth1 && mouseY >= buttonY11 && mouseY <= buttonY11 + buttonHeight1;
        if (isHovered1) {
            int hoverBoxColor = new Color(255, 255, 255, 100).getRGB();
            RoundedUtils.drawRoundedRect(buttonCenterX - 2, buttonY11 - 2, buttonCenterX + buttonWidth1 + 2, buttonY11 + buttonHeight1 + 2, 5.0f, hoverBoxColor);
        }
        ClickGUI.drawScaledCustomSizeModalRect(buttonCenterX, buttonY11, 0.0f, 0.0f, buttonWidth1, buttonHeight1, buttonWidth1, buttonHeight1, buttonWidth1, buttonHeight1);
        if (this.showColorBar) {
            int colorBarX = buttonCenterX - 50;
            int colorBarY = buttonY11 - 60;
            int colorBarWidth = 100;
            int colorBarHeight = 50;
            int colorBarColor = new Color(255, 0, 0).getRGB();
            RoundedUtils.drawRoundedRect(colorBarX, colorBarY, colorBarX + colorBarWidth, colorBarY + colorBarHeight, 5.0f, colorBarColor);
        }
        int searchBarPadding = 10;
        int searchBarX = mainContentX + searchBarPadding;
        int searchBarY = mainContentY + 10;
        int searchBarWidth = mainContentWidth - 2 * searchBarPadding;
        int searchBarHeight = 20;
        int searchBarColor = new Color(20, 20, 20).getRGB();
        RoundedUtils.drawRoundedRect(searchBarX, searchBarY, searchBarX + searchBarWidth, searchBarY + searchBarHeight, 20.0f, searchBarColor);
        FontUtil.normal.drawString(this.searchText, searchBarX + 20, searchBarY + (searchBarHeight - this.mc.fontRendererObj.FONT_HEIGHT) / 2, new Color(255, 0, 255, alpha).getRGB());
        ResourceLocation searchIcon = new ResourceLocation("Astra/search.png");
        this.mc.getTextureManager().bindTexture(searchIcon);
        int buttonWidth11 = 15;
        int buttonHeight11 = 15;
        int buttonX11 = sidebarX + (sidebarWidth - buttonWidth11) / 2 + 42;
        int buttonY111 = sidebarY + sidebarHeight - buttonHeight11 - 252;
        ClickGUI.drawModalRectWithCustomSizedTexture(buttonX11, buttonY111, 0.0f, 0.0f, buttonWidth11, buttonHeight11, buttonWidth11, buttonHeight11);
        this.mc.getTextureManager().bindTexture(imageLocation);
        ClickGUI.drawScaledCustomSizeModalRect(sidebarX + 15, sidebarY + 5, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight, imageWidth, imageHeight);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        super.keyTyped(typedChar, keyCode);
        if (keyCode == 1) {
            this.mc.displayGuiScreen(null);
        } else if (keyCode == 14) {
            if (!this.searchText.isEmpty()) {
                this.searchText = this.searchText.substring(0, this.searchText.length() - 1);
            }
        } else if (Character.isLetterOrDigit(typedChar) || typedChar == ' ') {
            this.searchText = String.valueOf(this.searchText) + typedChar;
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int sidebarX = this.guiX - 25;
        int sidebarY = this.guiY;
        int sidebarWidth = 75;
        int sidebarHeight = this.guiHeight;
        int buttonWidth = 15;
        int buttonHeight = 15;
        int buttonX = sidebarX + (sidebarWidth - buttonWidth) / 2 - 9;
        int buttonY = sidebarY + sidebarHeight - buttonHeight - 10;
        if (mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight) {
            this.mc.displayGuiScreen(new HUDConfigScreen());
            return;
        }
        int scroll = Mouse.getDWheel();
        if (scroll != 0) {
            if (scroll > 0 && this.visibleStartIndex > 0) {
                this.visibleStartIndex -= 8;
                if (this.visibleStartIndex < 0) {
                    this.visibleStartIndex = 0;
                }
            } else if (scroll < 0 && this.visibleStartIndex < this.modButtons.size() - 8) {
                this.visibleStartIndex += 8;
            }
        }
        boolean clickOnMod = false;
        int i = this.visibleStartIndex;
        while (i < Math.min(this.modButtons.size(), this.visibleStartIndex + 8)) {
            ModButton modButton = this.modButtons.get(i);
            if (mouseX >= modButton.getX() && mouseX <= modButton.getX() + modButton.getWidth() && mouseY >= modButton.getY() && mouseY <= modButton.getY() + modButton.getHeight()) {
                modButton.onClick(mouseX, mouseY, mouseButton);
                clickOnMod = true;
                break;
            }
            ++i;
        }
        if (!clickOnMod) {
            return;
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            if (scroll > 0 && this.visibleStartIndex > 0) {
                this.visibleStartIndex -= 8;
                if (this.visibleStartIndex < 0) {
                    this.visibleStartIndex = 0;
                }
                this.scrollDirection = ScrollDirection.UP;
            } else if (scroll < 0 && this.visibleStartIndex < this.modButtons.size() - 8) {
                this.visibleStartIndex += 8;
                this.scrollDirection = ScrollDirection.DOWN;
            }
        }
    }

    static enum ScrollDirection {
        UP,
        DOWN;

    }
}

