/*
 * Decompiled with CFR 0.152.
 */
package astra.ui;

import astra.ui.auth.AltManagerGui;
import astra.util.RoundedUtils;
import astra.util.font.FontUtil;
import java.awt.Color;
import java.io.IOException;
import java.net.URI;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class AstraMainMenu
extends GuiScreen {
    private static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("Astra/logo.png");

    @Override
    public void initGui() {
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 2 - 40, "Singleplayer"));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 100, this.height / 2 - 15, "Multiplayer"));
        this.buttonList.add(new GuiButton(3, this.width / 2 - 100, this.height / 2 + 10, "Options"));
        this.buttonList.add(new GuiButton(6, this.width / 2 - 100, this.height / 2 + 35, "Accounts"));
        this.buttonList.add(new GuiButton(4, this.width / 2 - 100, this.height / 2 + 60, ""));
        this.buttonList.add(new GuiButton(5, this.width / 2 - 100, this.height / 2 + 60, "Quit"));
        super.initGui();
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id == 1) {
            this.mc.displayGuiScreen(new GuiSelectWorld(this));
        } else if (button.id == 2) {
            this.mc.displayGuiScreen(new GuiMultiplayer(this));
        } else if (button.id == 3) {
            this.mc.displayGuiScreen(new GuiOptions(this, this.mc.gameSettings));
        } else if (button.id == 4) {
            this.openDiscordLink();
        } else if (button.id == 5) {
            this.mc.shutdown();
        } else if (button.id == 6) {
            this.mc.displayGuiScreen(new AltManagerGui());
        }
        super.actionPerformed(button);
    }

    private void openDiscordLink() {
        try {
            URI uri = new URI("https://discord.gg/YXjtJGwRSc");
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object desktop = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(desktop, uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.mc.getTextureManager().bindTexture(new ResourceLocation("Astra/main_menu.png"));
        AstraMainMenu.drawModalRectWithCustomSizedTexture(0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        int logoWidth = 100;
        int logoHeight = 100;
        int logoX = (this.width - logoWidth) / 2;
        int logoY = (this.height - logoHeight) / 2 - 110;
        this.mc.getTextureManager().bindTexture(LOGO_TEXTURE);
        Gui.drawModalRectWithCustomSizedTexture(logoX, logoY, 0.0f, 0.0f, logoWidth, logoHeight, logoWidth, logoHeight);
        int discordButtonWidth = 20;
        int discordButtonHeight = 15;
        int discordButtonX = this.width - discordButtonWidth - 10;
        int discordButtonY = 10;
        ((GuiButton)this.buttonList.get((int)4)).xPosition = discordButtonX;
        ((GuiButton)this.buttonList.get((int)4)).yPosition = discordButtonY;
        ((GuiButton)this.buttonList.get((int)4)).width = discordButtonWidth;
        ((GuiButton)this.buttonList.get((int)4)).height = discordButtonHeight;
        boolean isHovered = mouseX >= discordButtonX && mouseX < discordButtonX + discordButtonWidth && mouseY >= discordButtonY && mouseY < discordButtonY + discordButtonHeight;
        ResourceLocation discordImageLocation = new ResourceLocation("Astra/discord.png");
        if (isHovered) {
            this.mc.getTextureManager().bindTexture(discordImageLocation);
            Gui.drawModalRectWithCustomSizedTexture(discordButtonX, discordButtonY, 0.0f, 0.0f, discordButtonWidth, discordButtonHeight, discordButtonWidth, discordButtonHeight);
        } else {
            this.mc.getTextureManager().bindTexture(discordImageLocation);
            Gui.drawModalRectWithCustomSizedTexture(discordButtonX, discordButtonY, 0.0f, 0.0f, discordButtonWidth, discordButtonHeight, discordButtonWidth, discordButtonHeight);
        }
        String username = this.mc.getSession().getUsername();
        FontRenderer fontRenderer = this.mc.fontRendererObj;
        int usernameWidth = fontRenderer.getStringWidth(username);
        int usernameX = 10;
        int usernameY = 20;
        int usernameRectWidth = usernameWidth + 6;
        int usernameRectHeight = fontRenderer.FONT_HEIGHT + 4;
        int usernameRectX = usernameX - 3;
        int usernameRectY = usernameY - 2;
        RoundedUtils.drawRoundedRect(usernameRectX, usernameRectY, usernameRectX + usernameRectWidth, usernameRectY + usernameRectHeight, 5.0f, new Color(0, 0, 0, 170).getRGB());
        FontUtil.normal.drawStringWithShadow(username, usernameX, usernameY, Color.WHITE.getRGB());
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

