/*
 * Decompiled with CFR 0.152.
 */
package astra.cosmetics.impl;

import astra.cosmetics.CosmeticBase;
import astra.cosmetics.CosmeticController;
import astra.cosmetics.CosmeticModelBase;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CosmeticTopHat
extends CosmeticBase {
    private final ModelTopHat modelTopHat;
    private static final ResourceLocation TEXTURE = new ResourceLocation("Astra/hat.png");

    public CosmeticTopHat(RenderPlayer renderPlayer) {
        super(renderPlayer);
        this.modelTopHat = new ModelTopHat(renderPlayer);
    }

    @Override
    public void render(AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch, float scale) {
        if (CosmeticController.shouldRenderTophat(player)) {
            GlStateManager.pushMatrix();
            this.playerRenderer.bindTexture(TEXTURE);
            if (player.isSneaking()) {
                GL11.glTranslated((double)0.0, (double)0.225, (double)0.0);
            }
            float[] color = CosmeticController.getTopHatColor(player);
            GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
            this.modelTopHat.render(player, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch, scale);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    private class ModelTopHat
    extends CosmeticModelBase {
        private ModelRenderer rim;
        private ModelRenderer pointy;

        public ModelTopHat(RenderPlayer player) {
            super(player);
            this.rim = new ModelRenderer(this.playerModel, 0, 0);
            this.rim.addBox(-5.5f, -9.0f, -5.5f, 11, 2, 11);
            this.pointy = new ModelRenderer(this.playerModel, 0, 13);
            this.pointy.addBox(-3.5f, -17.0f, -3.5f, 7, 8, 7);
        }

        @Override
        public void render(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch, float scale) {
            this.rim.rotateAngleX = this.playerModel.bipedHead.rotateAngleX;
            this.rim.rotateAngleY = this.playerModel.bipedHead.rotateAngleY;
            this.rim.rotationPointX = 0.0f;
            this.rim.rotationPointY = 0.0f;
            this.rim.render(scale);
            this.pointy.rotateAngleX = this.playerModel.bipedHead.rotateAngleX;
            this.pointy.rotateAngleY = this.playerModel.bipedHead.rotateAngleY;
            this.pointy.rotationPointX = 0.0f;
            this.pointy.rotationPointY = 0.0f;
            this.pointy.render(scale);
        }
    }
}

