/*
 * Decompiled with CFR 0.152.
 */
package astra.cosmetics;

import astra.cosmetics.CosmeticController;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;

public class CapeRenderer
implements LayerRenderer<AbstractClientPlayer> {
    private static final ResourceLocation CAPE_TEXTURE = new ResourceLocation("your_mod_id", "textures/cape.png");
    private final RenderPlayer playerRenderer;
    private boolean renderCape = false;

    public CapeRenderer(RenderPlayer playerRenderer) {
        this.playerRenderer = playerRenderer;
    }

    @Override
    public void doRenderLayer(AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.renderCape && CosmeticController.shouldRenderCape(player)) {
            this.renderCape(player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }

    private void renderCape(AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.playerRenderer.bindTexture(CAPE_TEXTURE);
    }

    public void setRenderCape(boolean renderCape) {
        this.renderCape = renderCape;
    }
}

